<?php
// Use require_once with __DIR__ to prevent path issues and infinite inclusion loops
require_once __DIR__ . '/includes/header.php';

$query = $_GET['q'] ?? '';
$results = [];

if ($query) {
    // Search in name or description
    // Use wildcards % for partial matching
    $searchKey = "%" . $query . "%";
    $stmt = $pdo->prepare("SELECT * FROM products WHERE name LIKE ? OR description LIKE ? ORDER BY id DESC");
    $stmt->execute([$searchKey, $searchKey]);
    $results = $stmt->fetchAll();
}
?>

<style>
    /* --- Custom Product Card Design --- */
    .product-card {
        border: none;
        border-radius: 20px;
        box-shadow: 0 10px 25px rgba(0,0,0,0.05);
        overflow: hidden;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        background: #fff;
        height: 100%;
        display: flex;
        flex-direction: column;
    }
    .product-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 15px 35px rgba(0,0,0,0.1);
    }
    .product-img-wrapper {
        background-color: #fff; /* White Background */
        padding: 30px;
        position: relative;
        height: 280px;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: background-color 0.3s ease;
    }
    .product-img-wrapper img {
        max-height: 100%;
        max-width: 100%;
        object-fit: contain;
        filter: drop-shadow(0 5px 15px rgba(0,0,0,0.1));
        transition: transform 0.3s ease;
    }
    .product-card:hover .product-img-wrapper img {
        transform: scale(1.05);
    }
    .card-body-custom {
        padding: 25px;
        text-align: center;
        flex-grow: 1;
        display: flex;
        flex-direction: column;
        justify-content: space-between;
        transition: background-color 0.3s ease;
    }
    .card-title {
        font-weight: 800;
        font-size: 1.1rem;
        margin-bottom: 5px;
        color: #2c3e50;
    }
    .card-desc {
        font-size: 0.85rem;
        color: #95a5a6;
        margin-bottom: 15px;
        line-height: 1.4;
    }
    .price-row {
        display: flex;
        justify-content: space-between;
        align-items: center;
        border-top: 1px solid #f0f0f0;
        padding-top: 20px;
        margin-top: auto;
    }
    .price-tag {
        font-size: 1.4rem;
        font-weight: 800;
        color: #2c3e50;
    }
    .btn-add-cart-custom {
        background: transparent;
        color: #2c3e50;
        border: 2px solid #2c3e50;
        padding: 8px 16px;
        border-radius: 8px;
        font-size: 0.75rem;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        transition: all 0.2s;
    }
    .btn-add-cart-custom:hover {
        background: #2c3e50;
        color: #fff;
    }
</style>

<div class="container my-5" style="min-height: 50vh;">
    <!-- Search Bar Section -->
    <div class="row justify-content-center mb-5">
        <div class="col-md-8">
            <form action="search.php" method="GET" class="d-flex gap-2">
                <input type="text" name="q" class="form-control form-control-lg" placeholder="Search for products" value="<?= htmlspecialchars($query) ?>">
                <button type="submit" class="btn btn-dark px-4">Search</button>
            </form>
        </div>
    </div>

    <!-- Results Section -->
    <?php if ($query): ?>
        <h4 class="mb-4">Search Results for <?= htmlspecialchars($query) ?> <small class="text-muted"></small></h4>
        
        <?php if (empty($results)): ?>
            <div class="alert alert-light text-center py-5 border">
                <h4>No products found.</h4>
                <p>Try different keywords or browse our <a href="index.php">collection</a>.</p>
            </div>
        <?php else: ?>
            <div class="row row-cols-1 row-cols-sm-2 row-cols-lg-4 g-4">
                <?php foreach($results as $p): ?>
                <div class="col">
                    <div class="product-card">
                        <!-- Clickable Image Area -->
                        <a href="product_detail.php?id=<?= $p['id'] ?>" class="text-decoration-none">
                            <div class="product-img-wrapper">
                                <img src="../../<?= $p['image'] ?>" alt="<?= htmlspecialchars($p['name']) ?>">
                            </div>
                        </a>
                        
                        <div class="card-body-custom">
                            <a href="product_detail.php?id=<?= $p['id'] ?>" class="text-decoration-none">
                                <h6 class="card-title text-truncate"><?= htmlspecialchars($p['name']) ?></h6>
                                <p class="card-desc text-truncate">
                                    Premium quality product for you
                                </p>
                            </a>

                            <div class="price-row">
                                <div class="price-tag">$<?= number_format($p['price'], 2) ?></div>
                                
                                <form action="cart.php" method="POST">
                                    <input type="hidden" name="product_id" value="<?= $p['id'] ?>">
                                    <input type="hidden" name="action" value="add">
                                    <button type="submit" class="btn-add-cart-custom">ADD TO CART</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>

    <?php endif; ?>
</div>

<?php 
// Safely include footer at the end
require_once __DIR__ . '/includes/footer.php'; 
?>