<?php
include 'includes/header.php';

$id = $_GET['id'] ?? null;
if (!$id) {
    echo "<script>window.location.href='index.php';</script>";
    exit;
}

$stmt = $pdo->prepare("SELECT * FROM products WHERE id = ?");
$stmt->execute([$id]);
$product = $stmt->fetch();

if (!$product) {
    echo "<div class='container mt-5'>Product not found.</div>";
    exit;
}
?>

<div class="container my-5">
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.php" class="text-dark">Home</a></li>
        <li class="breadcrumb-item active" aria-current="page"><?= htmlspecialchars($product['name']) ?></li>
      </ol>
    </nav>

    <div class="row mt-4">
        <!-- Image Section -->
        <div class="col-md-6 mb-4">
            <div style="background: #f8f8f8; overflow: hidden;">
                <img src="../../<?= $product['image'] ?>" class="img-fluid w-100" style="object-fit: cover; max-height: 600px;" alt="<?= htmlspecialchars($product['name']) ?>">
            </div>
        </div>

        <!-- Details Section -->
        <div class="col-md-6">
            <h2 class="mb-3"><?= htmlspecialchars($product['name']) ?></h2>
            <h3 class="mb-4 text-success">$<?= number_format($product['price'], 2) ?></h3>

            <div class="mb-4">
                <p><?= nl2br(htmlspecialchars($product['description'])) ?></p>
            </div>

            <!-- Add to Cart Form -->
            <form action="cart.php" method="POST" class="mb-4">
                <input type="hidden" name="product_id" value="<?= $product['id'] ?>">
                <input type="hidden" name="action" value="add">
                
                <div class="row g-2 align-items-center">
                    <div class="col-auto">
                        <select name="qty" class="form-select" style="width: 80px;">
                            <?php for($i=1; $i<=5; $i++): ?>
                                <option value="<?= $i ?>"><?= $i ?></option>
                            <?php endfor; ?>
                        </select>
                    </div>
                    <div class="col">
                        <button type="submit" class="btn btn-dark w-100 py-2 text-uppercase fw-bold">Add to Bag</button>
                    </div>
                </div>
            </form>

            <div class="border-top pt-3">
                <small class="text-muted"><i class="fas fa-truck me-2"></i> Free delivery on qualifying orders.</small><br>
                <small class="text-muted"><i class="fas fa-undo me-2"></i> 30-day return policy.</small>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php 
// Safely include footer at the end
require_once __DIR__ . '/includes/footer.php'; 
?>