<?php
include 'includes/header.php';

// Handle Delete
if (isset($_GET['delete'])) {
    $id = $_GET['delete'];
    
    // Optional: Delete actual file from server to save space
    $stmt = $pdo->prepare("SELECT image_path FROM slider_images WHERE id = ?");
    $stmt->execute([$id]);
    $img = $stmt->fetch();
    if ($img && file_exists('../' . $img['image_path'])) {
        // unlink('../' . $img['image_path']); // Uncomment to actually delete files
    }

    $pdo->prepare("DELETE FROM slider_images WHERE id = ?")->execute([$id]);
    echo "<script>window.location.href='slider_images.php';</script>";
}

// Handle Add
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $title = $_POST['title'];
    $subtitle = $_POST['subtitle'];
    $link = $_POST['link'];
    $order = $_POST['sort_order'];
    
    $imagePath = '';
    if (!empty($_FILES['image']['name'])) {
        $uploaded = uploadImage($_FILES['image']);
        if ($uploaded) $imagePath = $uploaded;
    }

    if ($imagePath) {
        $sql = "INSERT INTO slider_images (image_path, title, subtitle, link, sort_order) VALUES (?, ?, ?, ?, ?)";
        $pdo->prepare($sql)->execute([$imagePath, $title, $subtitle, $link, $order]);
    }
}

$sliders = $pdo->query("SELECT * FROM slider_images ORDER BY sort_order ASC")->fetchAll();
?>

<!-- Page Heading -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="fw-bold text-dark mb-1">Slider Manager</h2>
        <p class="text-muted mb-0">Manage your homepage hero carousel.</p>
    </div>
    <span class="badge bg-primary rounded-pill px-3 py-2 fs-6 shadow-sm">
        <?= count($sliders) ?> Active Slides
    </span>
</div>

<div class="row g-4">
    <!-- Add Form Column -->
    <div class="col-lg-4">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-header bg-white py-3 fw-bold border-bottom d-flex align-items-center">
                <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-2" style="width: 32px; height: 32px;">
                    <i class="fas fa-plus"></i>
                </div>
                Add New Slide
            </div>
            <div class="card-body">
                <form method="POST" enctype="multipart/form-data">
                    <div class="mb-3">
                        <label class="form-label fw-bold small text-uppercase text-muted">Slide Image <span class="text-danger">*</span></label>
                        <input type="file" name="image" class="form-control" required accept="image/*">
                        <div class="form-text small"></div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold small text-uppercase text-muted">Title / Headline</label>
                        <input type="text" name="title" class="form-control" placeholder="">
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold small text-uppercase text-muted">Subtitle</label>
                        <input type="text" name="subtitle" class="form-control" placeholder="">
                    </div>

                    <div class="row">
                        <div class="col-md-8 mb-3">
                            <label class="form-label fw-bold small text-uppercase text-muted">Link URL</label>
                            <input type="text" name="link" class="form-control" placeholder="#">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label fw-bold small text-uppercase text-muted">Order</label>
                            <input type="number" name="sort_order" class="form-control" value="0">
                        </div>
                    </div>

                    <div class="d-grid mt-3">
                        <button type="submit" class="btn btn-dark fw-bold py-2">
                            <i class="fas fa-save me-2"></i> Save Slide
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- List Column -->
    <div class="col-lg-8">
        <div class="card shadow-sm border-0">
            <div class="card-header bg-white py-3 fw-bold border-bottom">
                <i class="fas fa-list text-primary me-2"></i> Current Slides
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="bg-light text-muted small text-uppercase">
                            <tr>
                                <th class="ps-4" style="width: 150px;">Preview</th>
                                <th>Content</th>
                                <th class="text-center">Order</th>
                                <th class="text-end pe-4">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(empty($sliders)): ?>
                                <tr>
                                    <td colspan="4" class="text-center py-5 text-muted">
                                        <div class="py-4">
                                            <i class="fas fa-images fa-3x mb-3 text-secondary opacity-25"></i>
                                            <p class="mb-0">No slides found.</p>
                                            <small>Use the form to add your first slide.</small>
                                        </div>
                                    </td>
                                </tr>
                            <?php else: ?>
                                <?php foreach($sliders as $s): ?>
                                <tr>
                                    <td class="ps-4 py-3">
                                        <!-- Fixed Aspect Ratio Box for Image Preview -->
                                        <div class="rounded border bg-light d-flex align-items-center justify-content-center overflow-hidden" style="width: 120px; height: 68px;">
                                            <img src="../<?= $s['image_path'] ?>" class="w-100 h-100" style="object-fit: cover;">
                                        </div>
                                    </td>
                                    <td>
                                        <h6 class="fw-bold text-dark mb-1"><?= htmlspecialchars($s['title'] ?: 'No Title') ?></h6>
                                        <div class="text-muted small mb-1"><?= htmlspecialchars($s['subtitle']) ?></div>
                                        <?php if($s['link'] && $s['link'] !== '#'): ?>
                                            <small class="badge bg-light text-primary border">
                                                <i class="fas fa-link me-1"></i> <?= htmlspecialchars($s['link']) ?>
                                            </small>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-center">
                                        <span class="badge bg-secondary text-white"><?= $s['sort_order'] ?></span>
                                    </td>
                                    <td class="text-end pe-4">
                                        <a href="slider_images.php?delete=<?= $s['id'] ?>" 
                                           class="btn btn-sm btn-outline-danger" 
                                           onclick="return confirm('Are you sure you want to delete this slide?')"
                                           title="Delete Slide">
                                            <i class="fas fa-trash-alt"></i>
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Closing divs matching the opening structure in header.php -->
</div></div></div>
</body>
</html>