<?php
include 'includes/header.php';

// Fetch current settings (assuming only 1 row exists, ID=1)
$settings = $pdo->query("SELECT * FROM company_settings WHERE id = 1")->fetch();

// If no settings exist yet, create a dummy array to avoid errors
if (!$settings) {
    $settings = ['id' => 1, 'company_name' => '', 'header_bg_color' => '#ffffff', 'logo_path' => '', 'sidebar_image_path' => ''];
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $companyName = $_POST['company_name'];
    $bgColor = $_POST['header_bg_color'];
    
    // Image Handling
    $logoPath = $settings['logo_path'];
    if (!empty($_FILES['logo']['name'])) {
        $uploaded = uploadImage($_FILES['logo']);
        if ($uploaded) $logoPath = $uploaded;
    }

    $sidebarPath = $settings['sidebar_image_path'];
    if (!empty($_FILES['sidebar']['name'])) {
        $uploaded = uploadImage($_FILES['sidebar']);
        if ($uploaded) $sidebarPath = $uploaded;
    }

    // Check if row exists to Update or Insert
    $check = $pdo->query("SELECT id FROM company_settings WHERE id = 1")->fetch();
    
    if ($check) {
        $sql = "UPDATE company_settings SET company_name=?, header_bg_color=?, logo_path=?, sidebar_image_path=? WHERE id=1";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$companyName, $bgColor, $logoPath, $sidebarPath]);
    } else {
        $sql = "INSERT INTO company_settings (id, company_name, header_bg_color, logo_path, sidebar_image_path) VALUES (1, ?, ?, ?, ?)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$companyName, $bgColor, $logoPath, $sidebarPath]);
    }
    
    echo "<script>window.location.href='settings.php';</script>"; // Refresh to see changes
}
?>

<!-- Page Heading -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="fw-bold text-dark mb-1">Business Settings</h2>
        <p class="text-muted mb-0">Manage your store identity and branding.</p>
    </div>
</div>

<form method="POST" enctype="multipart/form-data">
    <div class="row g-4">
        
        <!-- General Settings Column -->
        <div class="col-lg-6">
            <div class="card shadow-sm border-0 h-100">
                <div class="card-header bg-white py-3 fw-bold border-bottom">
                    <i class="fas fa-info-circle text-primary me-2"></i> General Information
                </div>
                <div class="card-body">
                    <div class="mb-4">
                        <label class="form-label fw-bold small text-uppercase text-muted">Company Name</label>
                        <input type="text" name="company_name" class="form-control form-control-lg" value="<?= htmlspecialchars($settings['company_name']) ?>" placeholder="My Awesome Shop">
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold small text-uppercase text-muted">Header Background Color</label>
                        <div class="d-flex align-items-center">
                            <input type="color" name="header_bg_color" class="form-control form-control-color me-3" value="<?= htmlspecialchars($settings['header_bg_color']) ?>" title="Choose your color">
                            <span class="text-muted small">Selected: <?= htmlspecialchars($settings['header_bg_color']) ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Branding Assets Column -->
        <div class="col-lg-6">
            <div class="card shadow-sm border-0 h-100">
                <div class="card-header bg-white py-3 fw-bold border-bottom">
                    <i class="fas fa-paint-brush text-primary me-2"></i> Branding Assets
                </div>
                <div class="card-body">
                    
                    <!-- Logo Section -->
                    <div class="row mb-4">
                        <div class="col-md-4">
                            <label class="form-label fw-bold small text-uppercase text-muted d-block mb-2">Current Logo</label>
                            <div class="border rounded bg-light d-flex align-items-center justify-content-center p-2" style="height: 100px;">
                                <?php if($settings['logo_path']): ?>
                                    <img src="../<?= $settings['logo_path'] ?>" class="img-fluid" style="max-height: 100%;">
                                <?php else: ?>
                                    <span class="text-muted small">No Logo</span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-md-8">
                            <label class="form-label fw-bold small text-uppercase text-muted">Upload New Logo</label>
                            <input type="file" name="logo" class="form-control">
                            <div class="form-text small">Recommended height: 60px. Transparent PNG preferred.</div>
                        </div>
                    </div>

                    <hr class="text-muted opacity-25">

                    <!-- Sidebar Image Section -->
                    <div class="row">
                        <div class="col-md-4">
                            <label class="form-label fw-bold small text-uppercase text-muted d-block mb-2">Sidebar Image</label>
                            <div class="border rounded bg-light d-flex align-items-center justify-content-center p-2" style="height: 100px;">
                                <?php if($settings['sidebar_image_path']): ?>
                                    <img src="../<?= $settings['sidebar_image_path'] ?>" class="img-fluid" style="max-height: 100%;">
                                <?php else: ?>
                                    <span class="text-muted small">No Image</span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-md-8">
                            <label class="form-label fw-bold small text-uppercase text-muted">Upload Sidebar Image</label>
                            <input type="file" name="sidebar" class="form-control">
                            <div class="form-text small">Used for admin login or specific layouts.</div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <!-- Action Bar -->
    <div class="d-grid mt-4">
        <button type="submit" class="btn btn-dark fw-bold py-3 shadow-sm">
            <i class="fas fa-save me-2"></i> Save Changes
        </button>
    </div>

</form>

</div></div></div>
</body>
</html>